function test_suite = testUminus %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
x = polysym.empty;
y = -x;
assertTrue(isempty(y))

function testDefault
x = polysym;
y = -x;
assertEqual(y.Value,'0');

function testZero
x = polysym(0);
y = -x;
assertEqual(y.Value,'0');

function testUminusReal
x = polysym(pi);
y = -x;
assertEqual(y.Value,['-',x.Value]);

function testRealUminusChar
x = polysym('x');
y = -x;
assertEqual(y.Value,'-x');

function testUminusVector
x = polysym(1:3);
y = -x;
assertEqual(y(1).Value,'-1');
assertEqual(y(2).Value,'-2');
assertEqual(y(3).Value,'-3');

function testCompoundExpression
x = polysym('4+y');
y = -x;
assertEqual(y.Value,'-(4+y)');

function testMultiplicativeExpression
x = polysym('4*y');
y = -x;
assertEqual(y.Value,'-4*y');
